/*---------------------------------------------------------------------------*\

	FILE....: kldrop.h
	TYPE....: C Function
	AUTHOR..: David Rowe
	DATE....: 17/8/02
	AUTHOR..: Ben Kramer
	DATE....: 29/1/03

	Kernel based loop drop detection module for V12PCI, links with hda.c

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Voicetronix Voice Processing Board (VPB) Software

	Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	USA

\*---------------------------------------------------------------------------*/

#ifndef __KLDROP
#define __KLDROP

void *kldrop_open(unsigned short *base2);
void kldrop_close(void *kldrop);
void kldrop_sample(void *kldrop, int btb);
int kldrop_read(void *kldrop, int ch);
int kldrop_getevt(void *kldrop);

// user supplied support functions, must be linked in by caller

void *kldrop_malloc(int size);
void kldrop_free(void *mem);
int kldrop_readw(unsigned short *addr);

#endif





